#ifndef METASPRITE_H_
#define METASPRITE_H_

#include "types.h"


//first sprite is not defined from metaSprite.x/.y/.tile
//this way I could use a metaSprite at (0,0)
//but its first subSprite at (3,2) for ex
//==> not squared sprites !!
typedef struct
{
	unsigned char xOffset, yOffset;
	unsigned char tileOffset;
	signed char reservedSprite; //, or -1
}subSprite;


//metasprite is a logic sprite
//real SMS sprites are created from meta's subsprites
typedef struct
{
	unsigned int x, y;
	unsigned int tile;
	unsigned char nbSprites;
	//using a pointer to an array allows to store this array on ROM
	//generated by a (coming soon?) tool
	subSprite	(*sprites)[];
} metaSprite;

void addMetaSprite(metaSprite *msprite);
void updateMetaSpritePos(metaSprite *msprite);
void updateMetaSpriteTile(metaSprite *msprite);

#endif /* METASPRITE_H_ */
